#include <applications/dialog/CoefficientDialog.h>
#include <cstdio>
#include <hal/devices.h>
#include <hal/drivers/buzzer.h>
#include <applications/dialog/SettingDialog.h>

CCoefficientDialog CoefficientDialog;

void CCoefficientDialog::OnCreat(void)
{
	rewind(p_lcd);
	fwrite(zeros, 128, 1, p_lcd);

	rewind(p_lcd);
	fputs("Temperature", p_lcd);

	fseek(p_lcd, 16, SEEK_SET);
	fputs("coefficient:", p_lcd);

	fseek(p_lcd, 48, SEEK_SET);
	fputs("  Save   Cancel", p_lcd);

	in_edit = false;
	menu_item = c1;

	flash_file * p_flash_file;

	fseek(p_flash, (int) (&p_flash_file->temp_coef) - (int) (p_flash_file), SEEK_SET);
	fread(&coefficient, sizeof(flash_file::temp_coef), 1, p_flash);

	OnDraw();
}

void CCoefficientDialog::OnEncoderCW(void)
{
	if (in_edit)
	{
		switch (menu_item)
		{
		default:
			menu_item = c1;
		case c1:
			coefficient += 1;
			break;
		case c0_1:
			coefficient += 0.1f;
			break;
		case c0_01:
			coefficient += 0.01f;
			break;
		}

		if (coefficient > configure_file.max_temp_coef)
		{
			coefficient = configure_file.max_temp_coef;
			beep(10);
		}
	}
	else
	{
		switch (menu_item)
		{
		default:
		case c1:
			menu_item = c0_1;
			break;
		case c0_1:
			menu_item = c0_01;
			break;
		case c0_01:
			menu_item = save;
			break;
		case save:
			menu_item = cancel;
			break;
		case cancel:
			beep(10);
			return;
			break;
		}
	}

	OnDraw();
}

void CCoefficientDialog::OnEncoderCCW(void)
{
	if (in_edit)
	{
		switch (menu_item)
		{
		default:
			menu_item = c1;
		case c1:
			coefficient -= 1;
			break;
		case c0_1:
			coefficient -= 0.1f;
			break;
		case c0_01:
			coefficient -= 0.01f;
			break;
		}

		if (coefficient < configure_file.min_temp_coef)
		{
			coefficient = configure_file.min_temp_coef;
			beep(10);
		}
	}
	else
	{
		switch (menu_item)
		{
		case c1:
			beep(10);
			return;
			break;
		case c0_1:
			menu_item = c1;
			break;
		case c0_01:
			menu_item = c0_1;
			break;
		case save:
			menu_item = c0_01;
			break;
		default:
		case cancel:
			menu_item = save;
			break;
		}
	}

	OnDraw();
}

void CCoefficientDialog::OnButtonDown(void)
{
	flash_file * p_flash_file;

	switch (menu_item)
	{
	default:
		menu_item = c1;
	case c1:
	case c0_1:
	case c0_01:
		in_edit = !in_edit;
		break;
	case save:
		fseek(p_flash, (int) (&p_flash_file->temp_coef) - (int) (p_flash_file), SEEK_SET);
		fwrite(&coefficient, sizeof(flash_file::temp_coef), 1, p_flash);
		fflush(p_flash);
	case cancel:
		p_dialog = &SettingDialog;
		p_dialog->OnCreat();
		return;
		break;
	}

	OnDraw();
}

void CCoefficientDialog::OnDraw(void)
{
	fseek(p_lcd, 101, SEEK_SET);
	fwrite(zeros, 4, 1, p_lcd);

	fseek(p_lcd, 112, SEEK_SET);
	fwrite(zeros, 16, 1, p_lcd);

	fseek(p_lcd, 35, SEEK_SET);

	fprintf(p_lcd, "%+6.2f%%/\xf8\C", coefficient);

	switch (menu_item)
	{
	default:
		menu_item = c1;
	case c1:
		fseek(p_lcd, 101, SEEK_SET);
		fputc(0x1 + in_edit, p_lcd);
		break;
	case c0_1:
		fseek(p_lcd, 103, SEEK_SET);
		fputc(0x1 + in_edit, p_lcd);
		break;
	case c0_01:
		fseek(p_lcd, 104, SEEK_SET);
		fputc(0x1 + in_edit, p_lcd);
		break;
	case save:
		fseek(p_lcd, 112, SEEK_SET);
		fputs("\1\1\1\1\1\1\1\1", p_lcd);
		break;
	case cancel:
		fseek(p_lcd, 120, SEEK_SET);
		fputs("\1\1\1\1\1\1\1\1", p_lcd);
		break;
	}

	fflush(p_lcd);
}

